<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!-- Generates NavBar for every element -->
	<xsl:template name="ClassNavBar">
		<xsl:param name="class"></xsl:param>
		<xsl:param name="header"></xsl:param>
	
		<!-- Calculate relative path prefix -->
		<xsl:variable name="relativePrefix">
			<!--xsl:call-template name="RelativePathPrefix">
				<xsl:with-param name="element" select="$class"></xsl:with-param>
			</xsl:call-template-->
			<xsl:call-template name="GetCurrentPrefix"/>
		</xsl:variable>		
	
		<!-- Main Table -->		
		<table border="0" width="100%" cellpadding="1" cellspacing="0">
		<tr>
		<td colspan="2" class="NavBarCellCommon">
		<table border="0" cellpadding="0" cellspacing="3">
		<tr align="center" valign="top">
		
		<!-- OverView -->
		<xsl:call-template name="NavBarCell">
			<xsl:with-param name="name" select="$gOverview"></xsl:with-param>
			<xsl:with-param name="link" select="'overview-summary.html'"></xsl:with-param>
			<xsl:with-param name="relativePrefix" select="$relativePrefix"></xsl:with-param>
		</xsl:call-template>

		<!-- Package -->
		<xsl:call-template name="NavBarCell">
			<xsl:with-param name="name" select="$gPackage"></xsl:with-param>
			<xsl:with-param name="link" select="'package-summary.html'"></xsl:with-param>
		</xsl:call-template>
		
		<!-- Class -->
		<xsl:call-template name="NavBarCell">
			<xsl:with-param name="name" select="$gClass"></xsl:with-param>
			<xsl:with-param name="bold" select="'true'"></xsl:with-param>
		</xsl:call-template>

		<!-- Use -->
		<xsl:if test="$use_param">
			<xsl:variable name="className">
				<xsl:call-template name="classifierShortName">
					<xsl:with-param name="class" select="$class"></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:call-template name="NavBarCell">
				<xsl:with-param name="name" select="$gUse"></xsl:with-param>
				<xsl:with-param name="link" select="concat('class-use/', $className, '.html')"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Tree -->
		<xsl:if test="$tree_param">
			<xsl:call-template name="NavBarCell">
				<xsl:with-param name="name" select="$gTree"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Index - ALL -->
		<xsl:if test="$index_param">
			<xsl:call-template name="NavBarCell">
				<xsl:with-param name="name" select="$gIndex"></xsl:with-param>
				<xsl:with-param name="link" select="'index-all.html'"></xsl:with-param>
				<xsl:with-param name="relativePrefix" select="$relativePrefix"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Help -->
		<xsl:if test="$help_param">
			<xsl:call-template name="NavBarCell">
				<xsl:with-param name="name" select="$gHelp"></xsl:with-param>
				<xsl:with-param name="link" select="'help-doc.html'"></xsl:with-param>
				<xsl:with-param name="relativePrefix" select="$relativePrefix"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		</tr>
		</table>
		<!-- End of Main Table-->
		
		<xsl:call-template name="header_footer">
			<xsl:with-param name="header" select="$header"></xsl:with-param>
		</xsl:call-template>
		
		</td>
		</tr>
		
		<!-- Second Row Items -->
		<tr>
		
		<!-- Prev Next items-->
		<td class="NavBarCellPrevNext">
		<font size="-2">
		
		<!-- Insert reference to previous classifier -->
		<xsl:variable name="prevClass" select="preceding-sibling::Classifier[1]"></xsl:variable>
		<xsl:choose>
			<xsl:when test="$prevClass">
				<xsl:apply-templates select="$prevClass" mode="HRefWithImgLoad">
					<xsl:with-param name="isName" select="'2'"/>
					<xsl:with-param name="useName" select="concat($gPrev,' ')"/>
				</xsl:apply-templates>

				<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text> </xsl:text>
				<xsl:value-of select="$gPrev"></xsl:value-of>
				<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
		
		<!-- Insert reference to next classifier -->
		<xsl:variable name="nextClass" select="following-sibling::Classifier[1]"></xsl:variable>
		<xsl:choose>
			<xsl:when test="$nextClass">
				<xsl:apply-templates select="$nextClass" mode="HRefWithImgLoad">
					<xsl:with-param name="isName" select="'2'"/>
					<xsl:with-param name="useName" select="concat($gNext,' ')"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$gNext"></xsl:value-of>
			</xsl:otherwise>
		</xsl:choose>

		</font>
		</td>

		<!-- Frames -->
		<xsl:variable name="elementPath">
			<xsl:call-template name="RelPathResolver">
				<xsl:with-param name="element" select="$class"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="Frames">
			<xsl:with-param name="ref" select="$elementPath"></xsl:with-param>
			<xsl:with-param name="relativePrefix" select="$relativePrefix"></xsl:with-param>
		</xsl:call-template>
		</tr>

		<xsl:call-template name="SummaryDetailRow">
			<xsl:with-param name="element" select="$class"></xsl:with-param>
		</xsl:call-template>

		</table>
	</xsl:template>
	
	<!-- Generates links on element's summary and detail sections -->
	<xsl:template name="SummaryDetailRow">
		<xsl:param name="element"></xsl:param>
		<tr>
		<xsl:variable name="name" select="string($element/@name)"></xsl:variable>
		<xsl:variable name="fields" select="$element/Field"></xsl:variable>
		<xsl:variable name="methods" select="$element/Method[ not(@name=$name) and not (@isConstructor='true') and not(@name=concat('~',$name))]"></xsl:variable>
		<xsl:variable name="constructors" select="$element/Method[@name=$name] | Method[@isConstructor='true']"></xsl:variable>
		<xsl:variable name="destructors" select="$element/Method[@name=concat('~',$name)]"/>
		<xsl:variable name="classes" select="$element/child::Classifier"></xsl:variable>
		<xsl:variable name="inner">
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'Inner'"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="field">
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'Field'"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="constr">
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'Constr'"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="destr">
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'Destr'"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="method">
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'Method'"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>

		<!-- Summary section-->
		<td valign="top" class="NavBarCell3">
			<font size="-2">
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'Summary:'"></xsl:with-param>
			</xsl:call-template>
			
			<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
			
			<!-- inner classes -->
			<xsl:choose>
				<xsl:when test="$classes">
					<a href= "#inner_summary"><xsl:value-of select="$inner"></xsl:value-of></a>
					<xsl:text disable-output-escaping="yes">&amp;nbsp;|&amp;nbsp;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$inner"></xsl:value-of>
					<xsl:text disable-output-escaping="yes">&amp;nbsp;|&amp;nbsp;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
			
		
			<!-- field summary -->
			<xsl:choose>
				<xsl:when test="$fields">
					<a href= "#field_summary"><xsl:value-of select="$field"></xsl:value-of></a>
					<xsl:text disable-output-escaping="yes">&amp;nbsp;|&amp;nbsp;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$field"></xsl:value-of>
					<xsl:text disable-output-escaping="yes">&amp;nbsp;|&amp;nbsp;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
			

			<!-- constructor summary -->
			<xsl:choose>
				<xsl:when test="$constructors">
					<a href= "#constructor_summary"><xsl:value-of select="$constr"></xsl:value-of></a>
					<xsl:text disable-output-escaping="yes">&amp;nbsp;|&amp;nbsp;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$constr"></xsl:value-of>
					<xsl:text disable-output-escaping="yes">&amp;nbsp;|&amp;nbsp;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>

			<!-- destructor summary -->
			<xsl:choose>
				<xsl:when test="$destructors">
					<a href= "#destructor_summary"><xsl:value-of select="$destr"></xsl:value-of></a>
					<xsl:text disable-output-escaping="yes">&amp;nbsp;|&amp;nbsp;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$destr"></xsl:value-of>
					<xsl:text disable-output-escaping="yes">&amp;nbsp;|&amp;nbsp;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>

			<!-- method summary-->
			<xsl:choose>
				<xsl:when test="$methods">
					<a href= "#method_summary"><xsl:value-of select="$method"></xsl:value-of></a>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$method"></xsl:value-of>
				</xsl:otherwise>
			</xsl:choose>
			</font>
		</td>
		
		<!-- Detail section -->
		<td valign="top" class="NavBarCell3">
			<font size="-2">

			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'Detail:'"></xsl:with-param>
			</xsl:call-template>
			<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
		
			<!-- field detail -->
			<xsl:choose>
				<xsl:when test="$fields">
					<a href= "#field_detail"><xsl:value-of select="$field"></xsl:value-of></a>
					<xsl:text disable-output-escaping="yes">&amp;nbsp;|&amp;nbsp;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$field"></xsl:value-of>
					<xsl:text disable-output-escaping="yes">&amp;nbsp;|&amp;nbsp;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>

			<!-- constructor detail-->
			<xsl:choose>
				<xsl:when test="$constructors">
					<a href= "#constructor_detail"><xsl:value-of select="$constr"></xsl:value-of></a>
					<xsl:text disable-output-escaping="yes">&amp;nbsp;|&amp;nbsp;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$constr"></xsl:value-of>
					<xsl:text disable-output-escaping="yes">&amp;nbsp;|&amp;nbsp;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>

			<!-- destructor detail-->
			<xsl:choose>
				<xsl:when test="$destructors">
					<a href= "#destructor_detail"><xsl:value-of select="$destr"></xsl:value-of></a>
					<xsl:text disable-output-escaping="yes">&amp;nbsp;|&amp;nbsp;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$destr"></xsl:value-of>
					<xsl:text disable-output-escaping="yes">&amp;nbsp;|&amp;nbsp;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>

			<!-- method detail-->
			<xsl:choose>
				<xsl:when test="$methods">
					<a href= "#method_detail"><xsl:value-of select="$method"></xsl:value-of></a>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$method"></xsl:value-of>
				</xsl:otherwise>
			</xsl:choose>
			</font>
		</td>

		</tr>
	</xsl:template>
	
	
</xsl:stylesheet>
